
function tableWithXEmptyTables(x)
    local thisTable = {}
    for i = 1, x do
        table.insert(thisTable, {})
    end
    return thisTable
end

function applyToValueOrArray(valueOrArray, returningFunction, optionalReportingString)
    assert(valueOrArray, "applyToValueOrArray(...) can't be called if valueOrArray is nil")
    assert(returningFunction, "applyToValueOrArray(...) can't be called if returningFunction is nil")
    if type(valueOrArray) == "table" then
        for i, thing in ipairs(valueOrArray) do
            valueOrArray[i] = returningFunction(thing)
        end
        if optionalReportingString then
            local prefix = string.format("applyToValueOrArray(...) finished, optionalReporting: %s, returning array: ", optionalReportingString)
        end
        return valueOrArray
    else
        valueOrArray = returningFunction(valueOrArray)
        if optionalReportingString then
            print("applyToValueOrArray(...) finished, optionalReporting: "..optionalReportingString..", returning: ", valueOrArray)
        end
    end
    return valueOrArray
end

function tableHas(targetTable, candidate)
    assert(targetTable and candidate, "tableHas(...) can't be called with nil values")
    for key, element in pairs(targetTable) do
        if element == candidate then return true end
    end
    return false
end

function insertIfNotIn(targetTable, candidate)
    assert(targetTable and candidate, "insertIfNotIn(...) can't be called with nil values")
    if not tableHas(targetTable, candidate) then table.insert(targetTable, candidate) end
end

function removeIfIn(targetArray, candidate)
    assert(targetArray and candidate, "removeIfIn(...) can't be called with nil values")
    local indexes = {}
    for i, element in ipairs(targetArray) do
        if element == candidate then
            table.insert(indexes, i)
        end
    end
    for _, index in ipairs(indexes) do
        table.remove(targetArray, index)
    end
    for key, candidate in pairs(targetArray) do
        if element == candidate then
            targetArray[key] = nil
        end
    end
end

function tableWithXEmptyTables(x)
    local thisTable = {}
    for i = 1, x do
        table.insert(thisTable, {})
    end
    return thisTable
end
